# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 2
# Experiment: PMxPM, Run: 2
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B_MR2_strategy.txt
# LLM Suggested Fallback: D

def harmonious_illusionist(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not my_history:  # First round
        return "C"
    
    current_round = len(my_history) + 1
    total_rounds = 10
    
    # Check for always C or always D in opponent's code
    if "always C" in opponent_program_code.lower() or "return 'C'" in opponent_program_code:
        return "D"
    if "always D" in opponent_program_code.lower() or "return 'D'" in opponent_program_code:
        return "C"
    
    # Late-game strategy (rounds 7-10)
    if current_round >= 7:
        if current_round == total_rounds:  # Last round
            return "D"
        # Increase defection frequency
        if current_round % 2 == 0:
            return "D"
    
    # Mid-game strategy
    if len(opp_history) >= 1:
        if opp_history[-1] == "D":
            return "D"  # Retaliate immediately
        else:
            # Introduce occasional defection every 3rd round
            if current_round % 3 == 0:
                return "D"
    
    # Default to cooperation
    return "C"